/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org2.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org2.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org2.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPThread;

public class PHPStackFrame
extends PHPDebugElement
implements IStackFrame {
    private static final Pattern LAMBDA_FUNC_PATTERN = Pattern.compile("(.*)\\((\\d+)\\) : runtime-created function");
    private PHPThread fThread;
    private String fFunctionName;
    private String fFileName;
    private int fLineNumber;
    private int fId;
    private String fResName;

    public PHPStackFrame(IThread thread, String fileName, String funcName, int lineNumber, int id, String rName) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, funcName, lineNumber, id, rName);
    }

    public PHPStackFrame(IThread thread, String fileName, String funcName, int lineNumber, int id, StackLayer layer, String rName) {
        super((PHPDebugTarget)thread.getDebugTarget());
        this.baseInit(thread, fileName, funcName, lineNumber, id, rName);
    }

    private void baseInit(IThread thread, String fileName, String funcName, int lineNumber, int id, String rName) {
        Matcher matcher = LAMBDA_FUNC_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            fileName = matcher.group(1);
            lineNumber = Integer.parseInt(matcher.group(2));
        }
        this.fFunctionName = funcName;
        this.fFileName = fileName;
        this.fLineNumber = lineNumber;
        this.fId = id;
        this.fThread = (PHPThread)thread;
        this.fResName = rName;
    }

    public String createUID() {
        return this.fFileName + ':' + this.fFunctionName + ':' + this.fLineNumber;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables(this);
    }

    public boolean hasVariables() throws DebugException {
        return ((PHPDebugTarget)this.getDebugTarget()).getVariables(this).length > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int checkLineNumber() throws DebugException {
        return this.fLineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.fFunctionName;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fResName;
    }

    public String getAbsoluteFileName() {
        return this.fFileName;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public Expression[] getStackVariables() {
        return ((PHPDebugTarget)this.getDebugTarget()).getStackVariables(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fFunctionName == null ? 0 : this.fFunctionName.hashCode());
        result = 31 * result + this.fId;
        result = 31 * result + this.fLineNumber;
        result = 31 * result + (this.fResName == null ? 0 : this.fResName.hashCode());
        result = 31 * result + (this.fThread == null ? 0 : ((Object)((Object)this.fThread)).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PHPStackFrame other = (PHPStackFrame)((Object)obj);
        if (this.fFunctionName == null ? other.fFunctionName != null : !this.fFunctionName.equals(other.fFunctionName)) {
            return false;
        }
        if (this.fId != other.fId) {
            return false;
        }
        if (this.fLineNumber != other.fLineNumber) {
            return false;
        }
        if (this.fResName == null ? other.fResName != null : !this.fResName.equals(other.fResName)) {
            return false;
        }
        return !(this.fThread == null ? other.fThread != null : !((Object)((Object)this.fThread)).equals((Object)other.fThread));
    }
}

